import hashlib, json, numpy as np, os

def sha256_bytes(b: bytes) -> str:
    h = hashlib.sha256(); h.update(b); return h.hexdigest()

def sha256_file(path: str) -> str:
    with open(path, 'rb') as f: return sha256_bytes(f.read())

def json_dumps(obj) -> str:
    return json.dumps(obj, ensure_ascii=False, sort_keys=True, indent=2)

def ensure_dir(p: str):
    os.makedirs(p, exist_ok=True)

def center_of_mass(mask: np.ndarray):
    ys, xs = np.nonzero(mask)
    if len(xs) == 0: return mask.shape[0]//2, mask.shape[1]//2
    return int(np.round(np.mean(ys))), int(np.round(np.mean(xs)))
